<?php
/*
 * Plugin Name: Client List
 * Plugin URI: http://wptation.com
 * Description:
 * Version: 1.0
 * Author: Orkun Gürsel
 * Author URI: http://wptation.com
 * Shortcode:
 * Attributes:
 */

cloudfw_register_shortcode( 'CloudFw_Shortcode_Clients', NULL, 'advanced', 60 );
if ( ! class_exists('CloudFw_Shortcode_Clients') ) {
	class CloudFw_Shortcode_Clients extends CloudFw_Shortcodes {

		function get_called_class(){ return get_class($this); }

		var $parent	= 0;
		var $child	= 0;
		var $total	= 0;
		var $atts	= array();
		var $header	= '';
		var $footer	= '';
		var $content= '';

		function add() {
			return array(
				'clients_list' 	=> array( &$this, 'register_client_list' ),
				'client' 		=> array( &$this, 'register_client' ),
			);
		}

		/*
		 *	Shortcode: 	 [client_list]
		 */
		function register_client_list($atts, $content =  NULL, $case = NULL){
			$this->atts = shortcode_atts(array(
				"columns"           => 4,
				"shadow"            => 0,
				'carousel'          => 0,
				'sorting'           => '',

				'auto_rotate'       => 'FALSE',
				'animation_loop'    => 'FALSE',
				'arrows'            => 'FALSE',
				'disable_on_mobile' => 'FALSE',
				'rotate_time'       => '',
				'margin_top'        => '',
				'margin_bottom'     => '',
			), _check_onoff_false($atts));

			if ( (int) $this->atts['columns'] < 1 )
				$this->atts['columns'] = 1;

			extract( $this->atts );

			$this->parent++;
			$this->child = 0;
			$this->header = '';
			$this->footer = '';
			$this->contents = array();

			do_shortcode( $content );

			$unique_id = 'clients_'.$this->parent;

			$classes   = array();
			$classes[] = 'ui--client-list';
			$classes[] = 'ui--box';
			$classes[] = 'ui-row';
			$classes[] = 'clearfix';

			if ( $carousel ) {
				$classes[] = 'ui--carousel';
				wp_enqueue_script('theme-flexslider');
			}


			$this->header   = '<div class="ui--client-list-wrapper ui--animation ui-row clearfix"'.
				cloudfw_make_style_attribute( array(
					'margin-top'    => $margin_top,
					'margin-bottom' => $margin_bottom,
				), FALSE, TRUE ) .
			'>';
			$this->header  .= '<div'.
				cloudfw_make_class($classes, 1) .
				cloudfw_json_attribute( 'data-options', array(
					'effect'            => 'slide',
					'auto_rotate'       => $auto_rotate,
					'animation_loop'    => $animation_loop,
					'rotate_time'       => (int) $rotate_time * 1000,
					'arrows'            => _check_onoff( $arrows ),
					'disable_on_mobile' => _check_onoff( $disable_on_mobile ),
				), FALSE ) .
			'>';

			if ( $carousel ) {
				$this->header .= '<div class="slides">';
				$this->footer .= '</div>';
			}


			$this->footer .= '</div>';

			if ( $shadow ) {
				$this->footer .= cloudfw_UI_shadow( $shadow );
			}

			$this->footer .= '</div>';

			$contents_array = $this->contents;
			$total = count( (array) $contents_array );
			$this->contents = '';

			if ( is_array( $contents_array ) && ! empty( $contents_array ) ) {
				if ( $sorting == 'random' ) {
					@shuffle( $contents_array );
				}

				foreach ($contents_array as $item_number => $item_content) {
					$item_number++;
					$this->contents .= cloudfw_UI_column( array('_key' => 'client_list'), $item_content, '1of' . (int) $columns . ( $item_number % (int) $columns == 0 ? '_last' : '' ), $item_number == $total );
				}



			}

			return 	$this->header.
				 	$this->contents.
				 	$this->footer;
		}

		/*
		 *	Shortcode: 	 [client]
		 */
		function register_client($atts, $content =  NULL){
			extract(shortcode_atts(array(
				'img'				=> '',
				'alt'				=> '',
				'title'				=> '',
				'link'				=> '',
				'target'			=> '',
				'lightbox'			=> '',
				'lightbox_group'	=> '',
				'hover_content'	    => '',
			), _check_onoff_false($atts)));

			$this->child++;
			extract($this->atts);

			if ( $lightbox ) {
				$lightbox_group = esc_attr($lightbox_group);
				$lightbox_attr = empty($lightbox_group) ? 'prettyPhoto' : "prettyPhoto[{$lightbox_group}]";

				if ( empty($link) ) {
					$link = $img;
				}

			}

			$output  = '';
			$output .= '<div class="ui--client ui--carousel-item">';
				if ( $link ) {
					$output .= '<a href="'. $link .'"';

					if ( !empty($target) ) {
						$output .= ' target="'. $target .'"';
					}

					if ( !empty($lightbox_attr) ) {
						$output .= ' data-rel="'. $lightbox_attr .'"';
					}

					$output .= '>';
				}

					if ( !empty($img) ) {
						$output .= '<img src="'. $img .'" alt="' . $alt . '" title="' . $title . '" class="ui--animation">';
					} else {
						$output .= $title;
					}

					if ( ! empty( $hover_content ) ) {
						$output .= '<div class="ui--client-hover">';
							$output .= '<div class="ui--client-hover-content">';
								$output .= do_shortcode( $hover_content );
							$output .= '</div>';
						$output .= '</div>';
 					}

				if ( $link ) {
					$output .= '</a>';
				}

			$output .= '</div><div class="vertical-divider"></div>';


			$this->contents[] = $output;

		}


		/** Skin map */
		function skin_map( $map ){
			$map  -> id      ( 'client_hover_background' )
			      -> selector( '.ui--client-hover:before' )
			      -> attr    ( 'gradient', array('333333', '000000') )

				  -> id      ( 'client_hover_color' )
			      -> selector( '.ui--client-hover' )
			      -> attr    ( 'color', 'FFFFFF' )

				  -> id      ( 'client_hover_opacity' )
			      -> selector( '.ui--client:hover .ui--client-hover:before' )
			      -> attr    ( 'opacity', 90 );

			return $map;

		}

		/** Skin scheme */
		function skin_scheme( $schemes, $data ){
			return cloudfw_add_skin_scheme( 'shortcode',
				$schemes,
				array(
					'type'		=>	'module-set',
					'title'		=>	__('Client List','cloudfw'),
					'closable'	=>	true,
					'state'		=>	'closed',
					'layout'	=>	'subtab',
					'data'		=>	array(
						array(
							'type'		=>	'mini-section',
							'title'		=>	__('Hover Content','cloudfw'),
							'data'		=>	array(
								array(
									'type'		=>	'module',
									'ucode'		=>	'CLIENT LIST',
									'title'		=>	__('Color','cloudfw'),
									'data'		=>	array(

										array(
											'type'		=>	'color',
											'id'		=>	cloudfw_sanitize('client_hover_color','color'),
											'value'		=>	$data['client_hover_color']['color'],
										),

									)

								),
								array(
									'type'		=>	'module',
									'ucode'		=>	'CLIENT LIST',
									'title'		=>	__('Background Color','cloudfw'),
									'data'		=>	array(

										array(
											'type'		=>	'gradient',
											'id'		=>	cloudfw_sanitize('client_hover_background','gradient'),
											'value'		=>	$data['client_hover_background']['gradient'],
										),

									)

								),
								array(
									'type'		=>	'module',
									'ucode'		=>	'CLIENT LIST OPACITY',
									'title'		=>	__('Background Opacity','cloudfw'),
									'data'		=>	array(

										array(
											'type'		=>	'slider',
											'id'		=>	cloudfw_sanitize('client_hover_opacity','opacity'),
											'value'		=>	$data['client_hover_opacity']['opacity'],
											'min'		=>  1,
											'max'		=>  100,
											'step'		=>  1,
											'unit'		=>  '%',
										),

									)
								),
							),
						),
					),
				)
			);

		}
	}

}